﻿uses GraphABC;

procedure DrawMonkeysWithoutCoords();
var
  x0, y0, scaleX, scaleY: integer;
  
  function f(x: real): real;
  begin
    Result := Sqr(x/5 - 3) + 1 - x;
  end;
  
begin
  Window.Title := 'Индийские обезьяны граф';
  Window.SetSize(800, 600);
  
  // Настройки системы координат
  x0 := 100;      // Начало по X
  y0 := 333;      // Нулевая линия Y
  scaleX := 10;   // Масштаб по X
  scaleY := 10;   // Масштаб по Y
  
  // Ось X
  Pen.Color := Color.Black;
  Pen.Width := 2;
  Line(50, y0, 750, y0);
  
  // Ось Y
  Line(x0, 100, x0, 550);
  
  // Разметка оси X
  for var i := 0 to 60 do
    if i mod 5 = 0 then
    begin
      var xpos := x0 + i * scaleX;
      Line(xpos, y0 - 5, xpos, y0 + 5);
      TextOut(xpos - 8, y0 + 10, i.ToString);
    end;
  
  // Разметка оси Y
  for var i := -20 to 20 do
    if i mod 10 = 0 then
    begin
      var ypos := y0 - i * scaleY;
      Line(x0 - 5, ypos, x0 + 5, ypos);
      TextOut(x0 - 25, ypos - 8, i.ToString);
    end;
  
  // График функции f(x)
  Pen.Color := Color.Blue;
  Pen.Width := 3;
  
  var first := true;
  for var i := 0 to 60 do
  begin
    var x := i;
    var y := f(x);
    var xpos := x0 + x * scaleX;
    var ypos := y0 - Round(y * scaleY);
    
    if (ypos < 100) or (ypos > 550) then 
    begin
      first := true;
      continue;
    end;
    
    if first then
    begin
      MoveTo(xpos, ypos);
      first := false;
    end
    else
      LineTo(xpos, ypos);
  end;
  
  // Отмечаем корни x=5 и x=50
  var roots := Arr(5, 50);
  
  foreach var root in roots do
  begin
    var y_val := f(root);
    var xpos := x0 + root * scaleX;
    var ypos := y0 - Round(y_val * scaleY);
    
    // Красные точки
    Pen.Color := Color.Red;
    Pen.Width := 6;
    Circle(xpos, ypos, 8);
    
    // Вертикальные линии
    Pen.Color := Color.Gray;
    Pen.Width := 1;
    Pen.Style := psDash;
    Line(xpos, ypos, xpos, y0);
    Pen.Style := psSolid;
  end;
end;


begin
  DrawMonkeysWithoutCoords();
end.